/*
 * written by Steven Chaitoff
 */



/*
* LOADING/CHANGING PREFERENCES
*/


// functions for handling user prefs: file format, where captures are saved to, imported to, what do do after capturing
Preferences = {

save_location : '',
save_path : '',
save_name : '',
export_app : '',
after_capture : '',
image_format : '',

save_locations : ['clipboard', 'hard_drive'], 
after_captures : ['display_preview', 'save_to', 'export_to', 'save_and_export'], 
image_formats : ['jpg', 'png', 'tiff', 'gif', 'pdf'], 


save_loc_name : 
function() {
	if (this.save_location == this.save_locations[0]) return localize(this.save_location); // clipboard
	else return System.display_name(this.save_path);
},


export_app_name :
function() {
	return System.display_name(this.export_app);
},


save_loc_change :
function(sel) {
	var v = sel.options[sel.selectedIndex];
	this.save_location = v.value;
	document.getElementById('text_save_loc').innerText = v.text;

	var t = document.getElementById('text_after_capture');
	var s = document.getElementById('sel_after_capture');
	if (v.value == this.save_locations[0]) {
		document.getElementById('pref_save_path').style.display = 'none';
		t.innerHTML = '<span style="color:#fff"><i>' + localize('paste_images') + '</i></span>';
		s.disabled = 1;
	}
	else if (v.value == this.save_locations[1]) {
		var q = s.options[s.selectedIndex].text;
		document.getElementById('pref_save_path').style.display = 'block';
		t.innerText = q.charAt(0).toLowerCase() + q.substr(1);
		s.disabled = 0;
	}
},


save_name_change :
function(input) {
	var v = input.value.replace(/:/g, '/');
	if (v && v.charAt(0) != '.') input.value = this.save_name = v;
	else input.value = this.save_name; // do not save empty strings
},


export_app_change :
function(sel) {
	var s = sel.options[sel.selectedIndex];
	this.export_app = s.value;
	document.getElementById('text_export_app').innerText = s.text;
	document.getElementById('pref_export_app').title = s.value;
	this.after_capture_pref_location(2, this.export_app);
},


after_capture_change : 
function(sel) { // sel is after capture select box
	var s = sel.options[sel.selectedIndex];
	this.after_capture = s.value;
	document.getElementById('text_after_capture').innerText = s.text.charAt(0).toLowerCase() + s.text.substr(1);
},


image_format_change : 
function(sel) { // sel is image format select box
	var v = sel.options[sel.selectedIndex].value;
	this.image_format = v;
	document.getElementById('text_image_format').innerText = v;
},


save_loc_build :
function() {
	var sel = document.getElementById('sel_save_loc');
	for (var i=0, j=this.save_locations.length; i<j; ++i) {
		sel.options[sel.options.length] = new Option(localize(this.save_locations[i]), this.save_locations[i]);
		if (this.save_location == this.save_locations[i]) sel.selectedIndex = i;
	}
	this.save_loc_change(sel);
},


save_name_build :
function() {
	document.getElementById('input_save_name').value = this.save_name;
},


// System.list_image_apps requires the path to a known image file, 
// so get path of widget directory and use an image guaranteed to exist there
// cannot reference 'this.export_app' because 'this' refers to AsyncUNIXScript
export_app_build :
function(syscall) {
	if (!syscall) return widget.system("/bin/pwd", this.export_app_build);
	var pref_app_listed = false;
	var pref_app = Preferences.export_app;
	var pref_name = pref_app ? System.display_name(pref_app) : '';

	var sel = document.getElementById('sel_export_app');
	// use the ssp icon in the working dir (a known image file) to generate all image-opening apps with Launch Services
	var app_list = System.list_image_apps(syscall.outputString.slice(0,-1) + '/Icon.png');

	for (var i=0, j=app_list.length; i<j; ++i) {
		// load the users pref_app in the correct place in the list
		if (!pref_app_listed && pref_app && pref_name.toLowerCase() < System.display_name(app_list[i]).toLowerCase())
			sel.options[sel.options.length] = new Option(pref_name, pref_app);
		else
			sel.options[sel.options.length] = new Option(System.display_name(app_list[i]), app_list[i]);
		if (pref_app == sel.options[i].value || !pref_app && app_list[i].match(/preview/i)) {
			sel.selectedIndex = i;
			pref_app_listed = true;
		}
	}
	Preferences.export_app = sel.options[sel.selectedIndex].value;
	document.getElementById('text_export_app').innerText = sel.options[sel.selectedIndex].text;
	document.getElementById('pref_export_app').title = sel.options[sel.selectedIndex].value;
	
	Preferences.after_capture_pref_location(2, Preferences.export_app);
},


after_capture_build :
function() {
	var sel = document.getElementById('sel_after_capture');
	for (var i=0, j=this.after_captures.length; i<j; ++i) {
		sel.options[sel.options.length] = new Option(localize(this.after_captures[i]), this.after_captures[i]);
		if (this.after_capture == this.after_captures[i]) sel.selectedIndex = i;
	}
	var s = sel.options[sel.selectedIndex].text;
	document.getElementById('text_after_capture').innerText = s.charAt(0).toLowerCase() + s.substr(1);
},


image_format_build :
function() {
	var sel = document.getElementById('sel_image_format');
	for (var i=0, j=this.image_formats.length; i<j; ++i) {
		sel.options[sel.options.length] = new Option(this.image_formats[i].toUpperCase(), this.image_formats[i]);
		if (this.image_format == this.image_formats[i]) sel.selectedIndex = i;
	}
	document.getElementById('text_image_format').innerText = sel.options[sel.selectedIndex].value;
},


// update after_capture preference with the selected path of export_app or save_location
after_capture_pref_location :
function(pref_index, path) {
	var sel_after_capture = document.getElementById('sel_after_capture');
	sel_after_capture.options[pref_index].text = localize(this.after_captures[pref_index]) + ' ' + System.display_name(path);
	if (sel_after_capture.selectedIndex == pref_index && this.save_location != this.save_locations[0])
		document.getElementById('text_after_capture').innerText = sel_after_capture.options[pref_index].text;
},


load : 
function() {
	document.getElementById('input_save_name').value = 'asdf';

	this.save_location = widget.preferenceForKey(createKey('SAVE_LOCATION')) || this.save_locations[1];
	this.save_path = widget.preferenceForKey(createKey('SAVE_PATH')) || System.default_path();
	this.save_name = widget.preferenceForKey(createKey('SAVE_NAME')) || 'screen-capture';
	this.export_app = widget.preferenceForKey(createKey('EXPORT_APP')) || '';
	this.after_capture = widget.preferenceForKey(createKey('AFTER_CAPTURE')) || this.after_captures[0];
	this.image_format = widget.preferenceForKey(createKey('IMAGE_FORMAT')) || this.image_formats[1];

	this.after_capture_build(); // save_loc and export_app are dependent on the sel options this builds, so make this first
	this.save_loc_build();
	this.save_name_build();
	this.export_app_build();
	this.image_format_build();

	this.auto_list();
},


save :
function() {
	widget.setPreferenceForKey(this.save_location, createKey('SAVE_LOCATION'));
	widget.setPreferenceForKey(this.save_path, createKey('SAVE_PATH'));
	widget.setPreferenceForKey(this.save_name, createKey('SAVE_NAME'));
	widget.setPreferenceForKey(this.export_app, createKey('EXPORT_APP'));
	widget.setPreferenceForKey(this.after_capture, createKey('AFTER_CAPTURE'));
	widget.setPreferenceForKey(this.image_format, createKey('IMAGE_FORMAT'));
},


clear :
function() {
	var keys = ['SAVE_LOCATION', 'SAVE_PATH', 'SAVE_NAME', 'EXPORT_APP', 'AFTER_CAPTURE', 'IMAGE_FORMAT'];
	for (var k in keys) widget.setPreferenceForKey(null,createKey(keys[k]));
},




auto_list :
function() {
	this.recurse_list(Preferences.save_path);	// add a div for each path component
	this.list_component(Preferences.save_path, true);	// add the final path component
	Preferences.after_capture_pref_location(1, Preferences.save_path);
},



recurse_list : 
function(path) {
	if (path != '/') {
		this.recurse_list(System.parent_path(path)); // go to the beginning of the list
		this.list_component(path, false); // now add the path components in the correct order
	}
},



list_component :
function(path, final_path) {
		if (!System.file_exists(path)) return this.save_path = System.parent_path(path);

		var component_elem = document.createElement('DIV');
		var component_text = document.createElement('SPAN');
		var component_sel = document.createElement('SELECT')

		var last_component = final_path ? null : System.last_component(path);
		var subdirs = System.list_subdirs(final_path ? path : System.parent_path(path));

		if (subdirs.length) {
			component_sel.options[0] = new Option('-', '-');
			for (var m=0, n=subdirs.length; m<n; ++m)
				component_sel.options[m+1] = new Option(
					System.display_name(subdirs[m]), 
					System.last_component(subdirs[m]), 
					System.last_component(subdirs[m]) == last_component
				);
			component_text.innerHTML = final_path ? '  <img src="Images/sel_arrow.png" />' : System.display_name(path) + '/';
		}
		component_sel.onchange = this.directory_change; // note: closure for each new select created
		component_elem.appendChild(component_text);
		component_elem.appendChild(component_sel);
		document.getElementById('pref_save_path').appendChild(component_elem);
},



directory_change :
function() { // onchange handler for path components in pref_save_path
	var p = this.parentNode, gp = p.parentNode;
	var dir = this.options[this.selectedIndex].value;
	while (p.nextSibling) { // remove every subpath component following this one
		gp.removeChild(p.nextSibling);
		Preferences.save_path = System.parent_path(Preferences.save_path); // update the path
	}
	
	if (dir == "-") gp.removeChild(p); // delete this directory
	else { // change this directory/add new one (handled the same)
		Preferences.save_path = System.add_component(Preferences.save_path, dir);
		this.previousSibling.innerHTML = System.display_name(Preferences.save_path) + "/";
	}
	Preferences.list_component(Preferences.save_path, true);	// add the new final path component
	Preferences.after_capture_pref_location(1, Preferences.save_path);
}


};





if (window.widget) widget.onremove = Preferences.clear;






/*
 * DRAG/DROP FILE HANDLING
 */


// when user drops an item onto the back of the widget,
// if it is an application, use it as the export_app
// if it is a file/folder, use the deepest path to it
// (possibly the entire thing) as the save_location
function dragdrop(event) {
	var uri = null;
	try {
	    uri = event.dataTransfer.getData("text/uri-list");
	}
	catch(ex) { }

	var path = System.url_path(uri);
	if (System.is_application(path)) {
		Preferences.export_app = path;
		var i, j;
		var d = System.display_name(path);
		var s = document.getElementById('sel_export_app');
		for (i=0, j=s.options.length; i<j; ++i) {
			if (s.options[i].value == path) break; // app already in list
			if (s.options[i].text.toLowerCase() > d.toLowerCase()) { // insert app in correct alphabetical place in list
				s.insertBefore(new Option(d, path), s.options[i]);
				break;
			}
		}
		if (i == j) s.options[s.options.length] = new Option(d, path); // add to end if app is last alphabetically
		s.selectedIndex = i;
		Preferences.export_app_change(s);	
		document.getElementById('text_export_app').innerText = d;
	}
	else {
		document.getElementById('pref_save_path').innerText = '/';
		if (!System.is_directory(path)) path = System.parent_path(path);
		Preferences.save_path = path;
		Preferences.auto_list();
	}
	event.stopPropagation();
	event.preventDefault();
}

function dragenter(event) {
	event.stopPropagation();
	event.preventDefault();
}

function dragover(event) {
	event.stopPropagation();
	event.preventDefault();
}

function dragleave(event) {
	event.stopPropagation();
	event.preventDefault();
}



